﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;

namespace ASP.NET_HtmlGenericControl_Sample_1
{
    public partial class GenericControlExplore : System.Web.UI.Page
    {
        //This variable (divPopover) is our div container.
        protected HtmlGenericControl divPopover = new HtmlGenericControl();

        //This variable (listPopover) will be our <ul>. 
        protected HtmlGenericControl listPopover = new HtmlGenericControl();

        //This variable (menu) will be our <li> that will be the child of <ul>
        protected List<HtmlGenericControl> menu = new List<HtmlGenericControl> { };

        //This variable (navigationItems) will be the text items of the anchor links that will be the child of li.
        protected string[] navigationItems = new string[] { "Home", "About", "Contact Us", "Who We Are", "Another Page" };

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.IsPostBack)
            {
                //Create the <div> container.
                if (this.divPopover != null)
                {
                    this.divPopover.TagName = "div";
                    this.divPopover.ID = "menus";
                    this.divPopover.Attributes.Add("class", "hide");
                }

                //Create the unordered list <ul>.
                if (this.listPopover != null)
                {
                    this.listPopover.TagName = "ul";
                    this.listPopover.Attributes.Add("class", "nav nav-pills nav-stacked");
                }

                //Create the list item <li>.
                menu.AddRange(new List<HtmlGenericControl> {
                                    new HtmlGenericControl { TagName = "li" },
                                    new HtmlGenericControl { TagName = "li" },
                                    new HtmlGenericControl { TagName = "li" },
                                    new HtmlGenericControl { TagName = "li" },
                                    new HtmlGenericControl { TagName = "li" }
                                });

                menu.ForEach((item) =>
                {
                    //Add the list item individually into the unordered list <ul>.
                    listPopover.Controls.Add(item);
                });

                //Iterate through the navigation items that will be used as the text of the anchor/<a> tag. 
                for (int i = 0; i < navigationItems.Length; i++)
                {
                    var anchor = new HtmlAnchor
                    {
                        HRef = "#",
                        InnerText = navigationItems[i],
                        Title = navigationItems[i]
                    };

                    anchor.Attributes.Add("class", "nav-link");
                    //Add the navigation item 
                    listPopover.Controls[i].Controls.Add(anchor);
                }

                //Add all of the constructed HTML structure to the div container.
                this.divPopover.Controls.Add(listPopover);

                //Add the div container to our page server controls, which in this case is Panel.
                this.Panel1.Controls.Add(divPopover);
            }
        }
    }
}